--********************************DISCLAIMER**************************************
--We do not support 32-bit versions of SQL Server due to memory constraints
--********************************************************************************

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM sysobjects WHERE OBJECTPROPERTY(id, N'IsProcedure') = 1)
BEGIN
 DROP PROCEDURE sp_PhoneCheck
END
GO


CREATE  PROCEDURE sp_PhoneCheck AS

-- DECLARE variables.
DECLARE @DataPath  char(100)
DECLARE @License char(256)
DECLARE @intObject int
DECLARE @intResult int
DECLARE @strRetval char(100)  
DECLARE @intRetval int
DECLARE @RecCnt float
DECLARE @Phone char(40)
DECLARE @Zip char(5)
DECLARE @AreaCode char(3)
DECLARE @Prefix char(3)
DECLARE @Suffix char(4)
DECLARE @NewAreaCode char(3)
DECLARE @City char(22)
DECLARE @State char(16)
DECLARE @CountryCode char(3)
DECLARE @Latitude char(16)
DECLARE @Longitude char(16)
DECLARE @TimeZone char(16)
DECLARE @TimeZoneCode char(16)
DECLARE @Results char(20)
DECLARE @MSA char(6)
DECLARE @PMSA char(6)
DECLARE @CountyName char(22)
DECLARE @CountyFips char(22)
DECLARE @Errors char(30) 
DECLARE @Validation char(30) 
DECLARE @ExchangeType char(10) 
DECLARE @PhoneType char(20) 


-- DECLARE a cursor from table name PHONELIST
DECLARE PhoneCursor cursor for select phone, zip from PHONELIST

/*********************** DATA FILE PATHS **********************
*    This sample sets the data file path to the installation  *
*  default.  If you installed your Melissa Data data files to *
*  a different path, enter that location it below.            *
*  The Data Files Directory must contain the following files: *
*  mdAddr.dat and ZIPNPA.TXT.                                 *
**************************************************************/
SET  @DataPath = 'c:\program files\melissa data\dqt\data' 

/********************** LICENSE STRINGS ************************
*     To unlock the full functionality of Phone Object,        *
* please call a sales representative at 1-800-MELISSA ext. 3   *
*         (1-800-635-4772 x3) for a license string.            *
*      Without a valid license string, Phone Object will       *
*                only code Nevada Phone Numbers.               *
*                 REPLACE "DEMO" with LICENSE STRING                    

*  SetLicenseString will also check for a valid license in the *
*  MDPHONE_LICENSE(Environment) variable. This allows you to   *
*  modify the license without recompiling the project          *
***************************************************************/ 
SET  @License = 'DEMO'

SET  @RecCnt = 0	-- Record count
SET  nocount on		

-- Create Phone object.
EXEC @intResult = sp_OACreate 'PhoneObject.PhoneCheck', @intObject OUT
IF @intResult <> 0
BEGIN
    RAISERROR ('Object Creation Error', 1, 2)
    RETURN
END  

-- Call the SetLicenseString Method
EXEC @intResult = sp_OAMethod @intObject, SetLicenseString,  @strRetval OUT, @License  

--Get Build Number
EXEC @intResult = sp_OAMethod @intObject, GetBuildNumber,  @strRetval OUT
PRINT 'Build Number=' + @strRetval

-- Initialize data files - use the default
EXEC @intResult = sp_OAMethod @intObject, Initialize, @intRetval OUT, @DataPath
IF @intResult <> 0 OR @intRetval <> 0
BEGIN
	PRINT @Datapath
	PRINT 'Initialize Error =' + str(@intRetval)
    EXEC @intResult = sp_OAMethod @intObject, GetInitializeErrorString,  @strRetval OUT
	PRINT '    Error String =' + @strRetval
    RAISERROR ('Initialize Error',  1, 2) 
    	RETURN
END  

--Get Database Date (Optional)
EXEC @intResult = sp_OAMethod @intObject, GetDatabaseDate,  @strRetval OUT
PRINT 'Database Date=' + @strRetval

OPEN PhoneCursor

-- Perform the first fetch.
FETCH NEXT FROM PhoneCursor INTO @phone, @zip

-- Check FETCH_STATUS to see if there are any more rows to fetch.
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @RecCnt = @RecCnt + 1	

	--Clear Properities
	EXEC @intResult =sp_OASetProperty @intObject, AreaCode, ''
	EXEC @intResult =sp_OASetProperty @intObject, NewAreaCode, ''
	EXEC @intResult =sp_OASetProperty @intObject, Prefix, ''
	EXEC @intResult =sp_OASetProperty @intObject, Suffix, ''
	
	
	-- Call the Phone Lookup method
	EXEC @intResult = sp_OAMethod @intObject, 'Lookup', @intRetval OUT, @phone, @zip
	IF @intResult <> 0
	BEGIN
		PRINT 'Error=' + str(@intResult)
		RAISERROR ('Lookup Method Error',  1, 2)
		EXEC @intResult =sp_OAGetProperty @intObject, Results, @Results OUT
		PRINT 'Results Code=' + str(@Results) 
		RETURN
	END  

	-- Retrieve information from the COM object
	EXEC @intResult =sp_OAGetProperty @intObject, [AreaCode], @AreaCode OUT
	EXEC @intResult =sp_OAGetProperty @intObject, [Prefix], @Prefix OUT
	EXEC @intResult =sp_OAGetProperty @intObject, [Suffix], @Suffix OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [City], @City OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [State], @State OUT
	EXEC @intResult =sp_OAGetProperty @intObject, [Latitude], @Latitude OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [Longitude], @Longitude OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [TimeZone], @TimeZone OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [TimeZoneCode], @TimeZoneCode OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [Results], @Results OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [MSA], @MSA OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [PMSA], @PMSA OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [CountryCode], @CountryCode OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [CountyName], @CountyName OUT
    EXEC @intResult =sp_OAGetProperty @intObject, [CountyFips], @CountyFips OUT

    IF @Results like '%PE%'
    BEGIN
       IF @Results like '%PE01%'
         BEGIN
            set @Errors='Area Code Not valid'
		 END
	   IF @Results like '%PE02%'
         BEGIN
            set @Errors='Blank Phone Number'
		 END
	   IF @Results like '%PE03%'
         BEGIN
            set @Errors='Phone Number Not valid'
		 END			   
	   IF @Results like '%PE04%'
         BEGIN
            set @Errors='Input has Multiple Matches'
		 END			
	   IF @Results like '%PE05%'
         BEGIN
            set @Errors='Phone Prefix Not Valid'
		 END			
	   IF @Results like '%PE05%'
         BEGIN
            set @Errors='Zip Code Not Valid'
		 END
    END
    ELSE
    BEGIN  
       set @Errors='No Errors'
    END

IF (@Results like '%PS01%') OR (@Results like '%PS02%')
    BEGIN
       IF @Results like '%PS01%'
         BEGIN
            set @Validation='Validated to 10 Digits'
		 END
	   IF @Results like '%PS02%'
         BEGIN
            set @Validation='Validated to 7 Digits'
		 END

	   IF @Results like '%PS07%'
         BEGIN
            set @ExchangeType='Cellular'
		 END			   
	   IF @Results like '%PS08%'
         BEGIN
            set @ExchangeType='Land Line'
		 END			
	   IF @Results like '%PS09%'
         BEGIN
            set @ExchangeType='VOIP'
		 END
			
	   IF @Results like '%PS10%'
         BEGIN
            set @PhoneType='Residential'
		 END
       IF @Results like '%PS11%'
         BEGIN
            set @PhoneType='Business'
		 END
       IF @Results like '%PS12%'
         BEGIN
            set @PhoneType='Small/Home Office'
		 END
    END
	
    -- Call the Correct Area Code method
	EXEC @intResult = sp_OAMethod @intObject, 'CorrectAreaCode', @intRetval OUT, @phone, @zip
	IF @intResult <> 0
	BEGIN
		PRINT 'Error=' + str(@intResult)
		RAISERROR ('CorrectAreaCode Method Error',  1, 2)
		EXEC @intResult =sp_OAGetProperty @intObject, Results, @Results OUT
		PRINT 'Results Code=' + str(@Results) 
		RETURN
	END
    -- get new area code if one is supplied
    EXEC @intResult =sp_OAGetProperty @intObject, [NewAreaCode], @NewAreaCode OUT
    
	
	-- Update the table with new information
	UPDATE PHONELIST SET [AreaCode] = @AreaCode, 
                         [Prefix] = @Prefix, 
                         [Suffix] = @Suffix, 
                         [NewAreaCode] = @NewAreaCode,
                         [City] = @City,
                         [State] = @State,
                         [Latitude] = @Latitude,
                         [Longitude] = @Longitude,
                         [TimeZone] = @TimeZone,
                         [TimeZoneCode] = @TimeZoneCode,
                         [CountryCode] = @CountryCode,
                         [CountyName] = @CountyName,
                         [CountyFips] = @CountyFips,
                         [MSA] = @MSA,
                         [PMSA] = @PMSA,
                         [Errors] = rtrim(@Errors),
                         [Validation] = @Validation,
                         [ExchangeType] = @ExchangeType,
                         [PhoneType] = @PhoneType,
                         [Results] = rtrim(@Results) where current of PhoneCursor
                        
	-- Get next record	
	FETCH NEXT FROM PhoneCursor into @Phone, @Zip
END

--Close and de-allocate cursor
CLOSE PhoneCursor
DEALLOCATE PhoneCursor

-- Destroy Phone Object.
EXEC @intResult = sp_OADestroy @intObject
IF @intResult <> 0
BEGIN
    RAISERROR ('Destroy Object Error', 1, 2)
    RETURN
END



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

